/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.summary;

import filenet.vw.api.VWWorkObject;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.VWTrkDataModel;
import filenet.vw.toolkit.runtime.VWTrkParticipant;
import filenet.vw.toolkit.runtime.VWTrkStepOccurrence;
import filenet.vw.toolkit.runtime.VWTrkWorkObject;
import filenet.vw.toolkit.runtime.dialog.VWLockWork;
import filenet.vw.toolkit.runtime.dialog.VWStatusDetailsDialog;
import filenet.vw.toolkit.runtime.dialog.VWUnlockWork;
import filenet.vw.toolkit.runtime.summary.VWSummaryInfoTableModel;
import filenet.vw.toolkit.runtime.summary.VWTrackerSummaryInfo;
import filenet.vw.toolkit.runtime.summary.images.VWImageLoader;
import filenet.vw.toolkit.runtime.summary.resources.VWResource;
import filenet.vw.toolkit.runtime.table.VWTrackerSummaryCellRenderer;
import filenet.vw.toolkit.utils.VWPopupMenu;
import filenet.vw.toolkit.utils.dialog.VWInformationStackDialog;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableHeaderRenderer;
import filenet.vw.toolkit.utils.table.VWTableSorter;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class VWSummaryInfoTable
extends VWTable
implements MouseListener,
ListSelectionListener {
    protected Frame m_parentFrame = null;
    private VWTrackerSummaryInfo m_summaryPanel = null;
    private boolean m_initialized = false;
    protected VWSummaryInfoTableModel m_tableModel = null;
    private VWTableSorter m_tableSorter = null;
    protected TableColumnModel m_columnModel = null;
    private int m_popupRow = -1;
    private VWPopupMenu m_popup = null;
    private JMenuItem m_miDisplayStep = null;
    private ActionListener m_miDisplayStepActionListener = null;
    private JMenuItem m_miStatusDetails = null;
    private ActionListener m_miStatusDetailsActionListener = null;
    private JMenuItem m_miInformationStack = null;
    private ActionListener m_miInformationStackActionListener = null;
    private JMenuItem m_miLock = null;
    private ActionListener m_miLockActionListener = null;
    private JMenuItem m_miUnlock = null;
    private ActionListener m_miUnlockActionListener = null;
    private boolean m_tabSelected = false;

    public VWSummaryInfoTable(Frame parentFrame, VWSummaryInfoTableModel tableModel) {
        this(parentFrame, null, tableModel);
    }

    public VWSummaryInfoTable(Frame parentFrame, VWTrackerSummaryInfo summaryPanel, VWSummaryInfoTableModel tableModel) {
        super(tableModel);
        this.m_parentFrame = parentFrame;
        this.m_summaryPanel = summaryPanel;
        this.m_tableModel = tableModel;
        this.init();
    }

    public VWSummaryInfoTable(Frame parentFrame, VWTableSorter tableSorter) {
        this(parentFrame, null, tableSorter);
    }

    public VWSummaryInfoTable(Frame parentFrame, VWTrackerSummaryInfo summaryPanel, VWTableSorter tableSorter) {
        super(tableSorter);
        this.m_parentFrame = parentFrame;
        this.m_summaryPanel = summaryPanel;
        TableModel tm = null;
        this.m_tableSorter = tableSorter;
        tm = tableSorter.getModel();
        if (tm != null && tm instanceof VWSummaryInfoTableModel) {
            this.m_tableModel = (VWSummaryInfoTableModel)tm;
        }
        this.init();
    }

    private void init() {
        this.m_columnModel = this.getColumnModel();
        VWTrackerSummaryCellRenderer renderer = new VWTrackerSummaryCellRenderer();
        TableColumn mapNameColumn = this.m_columnModel.getColumn(0);
        mapNameColumn.setCellRenderer(renderer);
        TableColumn stepNameColumn = this.m_columnModel.getColumn(1);
        stepNameColumn.setCellRenderer(renderer);
        TableColumn statusColumn = this.m_columnModel.getColumn(5);
        statusColumn.setCellRenderer(renderer);
        TableColumn participantColumn = this.m_columnModel.getColumn(3);
        participantColumn.setCellRenderer(renderer);
        TableColumn receivedDateColumn = this.m_columnModel.getColumn(4);
        receivedDateColumn.setCellRenderer(renderer);
        TableColumn occurrenceColumn = this.m_columnModel.getColumn(2);
        occurrenceColumn.setMinWidth(40);
        occurrenceColumn.setMaxWidth(40);
        occurrenceColumn.setHeaderRenderer(new VWTableHeaderRenderer(VWImageLoader.createImageIcon("occurrence.gif"), VWResource.s_occurrence));
        occurrenceColumn.setCellRenderer(renderer);
        TableColumn responseColumn = this.m_columnModel.getColumn(6);
        responseColumn.setCellRenderer(renderer);
        TableColumn commentsColumn = this.m_columnModel.getColumn(7);
        commentsColumn.setCellRenderer(renderer);
        this.setShowGrid(false);
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(false);
        this.setSelectionMode(0);
        this.initColumns();
        ListSelectionModel lsm = this.getSelectionModel();
        lsm.addListSelectionListener(this);
        this.m_initialized = true;
        this.addMouseListener(this);
    }

    protected void initColumns() {
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public void createPopup(MouseEvent evt) {
        Vector selectedWork;
        Object source = evt.getSource();
        if (source != this) {
            return;
        }
        Point point = evt.getPoint();
        int row = this.rowAtPoint(point);
        int col = this.columnAtPoint(point);
        if (row == -1 || col == -1) {
            return;
        }
        VWTrkDataModel dataModel = this.getDataModel();
        if (dataModel == null) {
            return;
        }
        col = this.convertColumnIndexToModel(col);
        if (!this.isRowSelected(row)) {
            this.setRowSelectionInterval(row, row);
        }
        this.m_popupRow = row;
        if (this.m_popup != null) {
            this.m_popup.removeAll();
        } else {
            this.m_popup = new VWPopupMenu();
        }
        if (row != -1 && this.m_tableSorter != null) {
            row = this.m_tableSorter.getRowNumber(row);
        }
        if (this.m_tableModel != null && this.m_summaryPanel != null) {
            if (this.m_miDisplayStep == null) {
                this.m_miDisplayStep = new JMenuItem(VWResource.s_displayStep);
                this.m_miDisplayStepActionListener = new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        VWTrkStepOccurrence occurrence;
                        if (VWSummaryInfoTable.this.m_tableModel == null) {
                            return;
                        }
                        int row = VWSummaryInfoTable.this.m_popupRow;
                        if (row != -1 && VWSummaryInfoTable.this.m_tableSorter != null) {
                            row = VWSummaryInfoTable.this.m_tableSorter.getRowNumber(row);
                        }
                        if ((occurrence = VWSummaryInfoTable.this.m_tableModel.getStepOccurrence(row)) != null && VWSummaryInfoTable.this.m_summaryPanel != null) {
                            VWSummaryInfoTable.this.m_summaryPanel.displayStepOccurrence(occurrence, true);
                        }
                    }
                };
                this.m_miDisplayStep.addActionListener(this.m_miDisplayStepActionListener);
            }
            this.m_popup.add(this.m_miDisplayStep);
        }
        VWStatusDetailsDialog dialog = this.getStatusDialog();
        if (this.m_miStatusDetails == null) {
            this.m_miStatusDetails = new JMenuItem(VWResource.s_ellipse.toString(VWResource.s_statusDetails));
            this.m_miStatusDetailsActionListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    VWStatusDetailsDialog statusDialog = VWSummaryInfoTable.this.getStatusDialog();
                    statusDialog = VWSummaryInfoTable.this.initStatusDialog();
                    if (statusDialog != null) {
                        statusDialog.setVisible(true);
                        VWSummaryInfoTable.this.setStatusInfo(statusDialog);
                    }
                }
            };
            this.m_miStatusDetails.addActionListener(this.m_miStatusDetailsActionListener);
        }
        this.m_popup.add(this.m_miStatusDetails);
        VWInformationStackDialog informationStackDialog = this.getInformationStackDialog();
        if (this.m_miInformationStack == null) {
            this.m_miInformationStack = new JMenuItem(VWResource.s_ellipse.toString(VWResource.s_informationStackView));
            this.m_miInformationStackActionListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    VWInformationStackDialog informationStackDialog = VWSummaryInfoTable.this.getInformationStackDialog();
                    informationStackDialog = VWSummaryInfoTable.this.initInformationStackDialog();
                    if (informationStackDialog != null) {
                        informationStackDialog.setVisible(true);
                        VWSummaryInfoTable.this.setInformationStackInfo(informationStackDialog);
                    }
                }
            };
            this.m_miInformationStack.addActionListener(this.m_miInformationStackActionListener);
        }
        if ((selectedWork = this.getSelectedWorkInTable()) != null && selectedWork.size() > 0) {
            this.m_popup.add(this.m_miInformationStack);
        }
        if (dataModel.isTracker()) {
            boolean bLockable = this.m_tableModel.isLockable(row);
            boolean bUnlockable = this.m_tableModel.isUnockable(row);
            if (bLockable || bUnlockable) {
                this.m_popup.add(new JSeparator());
            }
            if (bLockable) {
                if (this.m_miLock == null) {
                    this.m_miLock = new JMenuItem(VWResource.s_lock);
                    this.m_miLockActionListener = new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            try {
                                if (VWSummaryInfoTable.this.m_tableModel == null) {
                                    return;
                                }
                                int row = VWSummaryInfoTable.this.m_popupRow;
                                if (row != -1 && VWSummaryInfoTable.this.m_tableSorter != null) {
                                    row = VWSummaryInfoTable.this.m_tableSorter.getRowNumber(row);
                                }
                                Object item = VWSummaryInfoTable.this.m_tableModel.getItem(row);
                                VWLockWork lockWork = null;
                                if (item instanceof VWTrkStepOccurrence) {
                                    lockWork = new VWLockWork(VWSummaryInfoTable.this.m_parentFrame, (VWTrkStepOccurrence)item);
                                } else if (item instanceof VWTrkParticipant) {
                                    lockWork = new VWLockWork(VWSummaryInfoTable.this.m_parentFrame, (VWTrkParticipant)item);
                                }
                            }
                            catch (Exception ex) {
                                VWDebug.logException(ex);
                                JOptionPane.showMessageDialog(VWSummaryInfoTable.this.m_parentFrame, ex.getLocalizedMessage(), VWResource.s_lock, 1, null);
                            }
                            VWSummaryInfoTable.this.setRowSelectionInterval(VWSummaryInfoTable.this.m_popupRow, VWSummaryInfoTable.this.m_popupRow);
                        }
                    };
                    this.m_miLock.addActionListener(this.m_miLockActionListener);
                }
                this.m_popup.add(this.m_miLock);
            }
            if (bUnlockable) {
                if (this.m_miUnlock == null) {
                    this.m_miUnlock = new JMenuItem(VWResource.s_unlock);
                    this.m_miUnlockActionListener = new ActionListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void actionPerformed(ActionEvent e) {
                            VWUnlockWork unlockWork = null;
                            try {
                                Object item;
                                if (VWSummaryInfoTable.this.m_tableModel == null) {
                                    return;
                                }
                                int row = VWSummaryInfoTable.this.m_popupRow;
                                if (row != -1 && VWSummaryInfoTable.this.m_tableSorter != null) {
                                    row = VWSummaryInfoTable.this.m_tableSorter.getRowNumber(row);
                                }
                                if ((item = VWSummaryInfoTable.this.m_tableModel.getItem(row)) instanceof VWTrkStepOccurrence) {
                                    unlockWork = new VWUnlockWork(VWSummaryInfoTable.this.m_parentFrame, (VWTrkStepOccurrence)item);
                                } else if (item instanceof VWTrkParticipant) {
                                    unlockWork = new VWUnlockWork(VWSummaryInfoTable.this.m_parentFrame, (VWTrkParticipant)item);
                                }
                                if (unlockWork != null) {
                                    unlockWork.unlockWork();
                                }
                            }
                            catch (Exception ex) {
                                VWDebug.logException(ex);
                                JOptionPane.showMessageDialog(VWSummaryInfoTable.this.m_parentFrame, ex.getLocalizedMessage(), VWResource.s_unlock, 1, null);
                            }
                            finally {
                                if (unlockWork != null) {
                                    unlockWork.removeReferences();
                                    unlockWork = null;
                                }
                            }
                            VWSummaryInfoTable.this.setRowSelectionInterval(VWSummaryInfoTable.this.m_popupRow, VWSummaryInfoTable.this.m_popupRow);
                        }
                    };
                    this.m_miUnlock.addActionListener(this.m_miUnlockActionListener);
                }
                this.m_popup.add(this.m_miUnlock);
            }
        }
        this.m_popup.show(this, point.x, point.y);
    }

    private VWStatusDetailsDialog getStatusDialog() {
        if (!this.m_initialized) {
            return null;
        }
        VWTrkDataModel dataModel = this.getDataModel();
        if (dataModel != null) {
            return dataModel.getStatusDetailsDialog();
        }
        return null;
    }

    private void setStatusDialog(VWStatusDetailsDialog statusDialog) {
        VWTrkDataModel dataModel = this.getDataModel();
        if (dataModel != null) {
            dataModel.setStatusDetailsDialog(statusDialog);
        }
    }

    private VWStatusDetailsDialog initStatusDialog() {
        if (!this.m_initialized) {
            return null;
        }
        if (this.getDataModel() == null) {
            return null;
        }
        VWStatusDetailsDialog statusDialog = this.getStatusDialog();
        if (statusDialog == null) {
            ListSelectionModel lsm = this.getSelectionModel();
            lsm.addListSelectionListener(this);
            statusDialog = new VWStatusDetailsDialog(this.m_parentFrame);
            if (statusDialog != null) {
                this.setStatusDialog(statusDialog);
            }
        }
        return statusDialog;
    }

    private VWInformationStackDialog getInformationStackDialog() {
        if (!this.m_initialized) {
            return null;
        }
        VWTrkDataModel dataModel = this.getDataModel();
        if (dataModel != null) {
            return dataModel.getInformationStackDialog();
        }
        return null;
    }

    private void setInformationStackDialog(VWInformationStackDialog informationStackDialog) {
        VWTrkDataModel dataModel = this.getDataModel();
        if (dataModel != null) {
            dataModel.setInformationStackDialog(informationStackDialog);
        }
    }

    private VWInformationStackDialog initInformationStackDialog() {
        Vector selectedWork;
        if (!this.m_initialized) {
            return null;
        }
        VWTrkDataModel dataModel = this.getDataModel();
        if (dataModel == null) {
            return null;
        }
        VWInformationStackDialog informationStackDialog = this.getInformationStackDialog();
        if (informationStackDialog == null && (informationStackDialog = new VWInformationStackDialog(selectedWork = this.getSelectedWorkInTable(), this.m_parentFrame)) != null) {
            this.setInformationStackDialog(informationStackDialog);
        }
        return informationStackDialog;
    }

    private Vector getSelectedWorkInTable() {
        VWTrkDataModel dataModel = this.getDataModel();
        if (dataModel == null) {
            return null;
        }
        int row = this.getSelectedRow();
        if (row != -1 && this.m_tableSorter != null) {
            row = this.m_tableSorter.getRowNumber(row);
        }
        Vector<VWWorkObject> selectedWork = new Vector<VWWorkObject>();
        if (row != -1) {
            Vector WOVector;
            int j;
            VWTrkWorkObject trkWO = null;
            VWWorkObject workObject = null;
            Object item = this.m_tableModel.getItem(row);
            int mapId = -1;
            int stepId = -1;
            if (item != null && item instanceof VWTrkStepOccurrence) {
                mapId = ((VWTrkStepOccurrence)item).getStep().getMapId();
                stepId = ((VWTrkStepOccurrence)item).getStep().getStepId();
                Vector work = ((VWTrkStepOccurrence)item).getParticipantWorkObjectCollection();
                if (work != null) {
                    for (j = 0; j < work.size(); ++j) {
                        trkWO = (VWTrkWorkObject)work.elementAt(j);
                        if (trkWO != null) {
                            workObject = trkWO.getVWWorkObject();
                        }
                        if (workObject == null) continue;
                        selectedWork.addElement(workObject);
                    }
                }
            } else if (item != null && item instanceof VWTrkParticipant) {
                VWTrkParticipant participant = (VWTrkParticipant)item;
                mapId = participant.getStep().getMapId();
                stepId = participant.getStep().getStepId();
                if (participant != null) {
                    trkWO = participant.getParticipantWorkObject();
                }
                if (trkWO != null) {
                    workObject = trkWO.getVWWorkObject();
                }
                if (workObject != null) {
                    selectedWork.addElement(workObject);
                }
            }
            if (workObject == null && (WOVector = dataModel.getExceptionWO(mapId, stepId)) != null && WOVector.size() > 0) {
                for (j = 0; j < WOVector.size(); ++j) {
                    workObject = (VWWorkObject)WOVector.elementAt(j);
                    if (workObject == null) continue;
                    selectedWork.addElement(workObject);
                }
            }
        }
        return selectedWork;
    }

    public void tableChanged(TableModelEvent e) {
        int selectedRow = this.getSelectedRow();
        super.tableChanged(e);
        if (!this.m_initialized) {
            return;
        }
        int rows = this.getRowCount();
        if (rows > 0) {
            VWInformationStackDialog informationStackDialog;
            VWStatusDetailsDialog statusDialog;
            if (selectedRow >= rows) {
                this.removeRowSelectionInterval(0, rows - 1);
            }
            if ((statusDialog = this.getStatusDialog()) != null && statusDialog.isVisible() && this.m_summaryPanel != null && this.m_tabSelected) {
                this.setStatusInfo(statusDialog);
            }
            if ((informationStackDialog = this.getInformationStackDialog()) != null && informationStackDialog.isVisible() && this.m_summaryPanel != null && this.m_tabSelected) {
                this.setInformationStackInfo(informationStackDialog);
            }
        }
    }

    void updateStatusDetailsDialog() {
        VWStatusDetailsDialog statusDialog = this.getStatusDialog();
        if (statusDialog != null && statusDialog.isVisible()) {
            this.setStatusInfo(statusDialog);
        }
    }

    private void setStatusInfo(VWStatusDetailsDialog statusDialog) {
        int row = this.getSelectedRow();
        if (row != -1 && this.m_tableSorter != null) {
            row = this.m_tableSorter.getRowNumber(row);
        }
        if (statusDialog != null && statusDialog.isVisible() && this.m_tableModel != null) {
            if (row != -1) {
                statusDialog.setMapName(this.m_tableModel.getMapName(row));
                statusDialog.setStepName(this.m_tableModel.getStepName(row));
                statusDialog.setOccurrence(this.m_tableModel.getOccurrence(row));
                statusDialog.setParticipant(this.m_tableModel.getParticipantName(row));
                statusDialog.setOperation(this.m_tableModel.getOperationName(row));
                statusDialog.setReceived(this.m_tableModel.getValueAt(row, 4));
                statusDialog.setStatus(this.m_tableModel.getValueAt(row, 5));
                statusDialog.setResponse(this.m_tableModel.getValueAt(row, 6));
                statusDialog.setComments(this.m_tableModel.getValueAt(row, 7));
            } else {
                statusDialog.clearAll();
            }
        }
    }

    void updateInformationStackDialog() {
        VWInformationStackDialog informationStackDialog = this.getInformationStackDialog();
        if (informationStackDialog != null && informationStackDialog.isVisible()) {
            this.setInformationStackInfo(informationStackDialog);
        }
    }

    private void setInformationStackInfo(VWInformationStackDialog informationStackDialog) {
        int row = this.getSelectedRow();
        if (row != -1 && this.m_tableSorter != null) {
            row = this.m_tableSorter.getRowNumber(row);
        }
        if (informationStackDialog != null && informationStackDialog.isVisible() && this.m_tableModel != null) {
            Vector<VWWorkObject> selectedWork = new Vector<VWWorkObject>();
            if (row != -1) {
                Vector WOVector;
                VWTrkDataModel dataModel;
                VWTrkWorkObject trkWO = null;
                VWWorkObject workObject = null;
                int mapId = -1;
                int stepId = -1;
                Object item = this.m_tableModel.getItem(row);
                if (item != null && item instanceof VWTrkStepOccurrence) {
                    mapId = ((VWTrkStepOccurrence)item).getStep().getMapId();
                    stepId = ((VWTrkStepOccurrence)item).getStep().getStepId();
                    Vector work = ((VWTrkStepOccurrence)item).getParticipantWorkObjectCollection();
                    if (work != null) {
                        for (int j = 0; j < work.size(); ++j) {
                            trkWO = (VWTrkWorkObject)work.elementAt(j);
                            if (trkWO != null) {
                                workObject = trkWO.getVWWorkObject();
                            }
                            if (workObject == null) continue;
                            selectedWork.addElement(workObject);
                        }
                    }
                } else if (item != null && item instanceof VWTrkParticipant) {
                    VWTrkParticipant participant = (VWTrkParticipant)item;
                    mapId = participant.getStep().getMapId();
                    stepId = participant.getStep().getStepId();
                    if (participant != null) {
                        trkWO = ((VWTrkParticipant)item).getParticipantWorkObject();
                    }
                    if (trkWO != null) {
                        workObject = trkWO.getVWWorkObject();
                    }
                    if (workObject != null) {
                        selectedWork.addElement(workObject);
                    }
                }
                if (workObject == null && (dataModel = this.getDataModel()) != null && (WOVector = dataModel.getExceptionWO(mapId, stepId)) != null && WOVector.size() > 0) {
                    for (int i = 0; i < WOVector.size(); ++i) {
                        workObject = (VWWorkObject)WOVector.elementAt(i);
                        if (workObject == null) continue;
                        selectedWork.addElement(workObject);
                    }
                }
            }
            informationStackDialog.updateDialog(selectedWork);
        }
    }

    VWTrkDataModel getDataModel() {
        if (this.m_tableModel != null) {
            return this.m_tableModel.getDataModel();
        }
        return null;
    }

    public void mouseClicked(MouseEvent event) {
        if (!this.m_initialized) {
            return;
        }
        if (event.getSource() != this) {
            return;
        }
        if (event.getClickCount() == 2) {
            VWTrkStepOccurrence stepOccurrence;
            Point point = event.getPoint();
            int row = this.rowAtPoint(point);
            int col = this.columnAtPoint(point);
            if (row == -1 || col == -1) {
                return;
            }
            VWStatusDetailsDialog statusDialog = this.initStatusDialog();
            if (statusDialog != null) {
                statusDialog.setVisible(true);
                this.setStatusInfo(statusDialog);
            }
            if (row != -1 && this.m_tableSorter != null) {
                row = this.m_tableSorter.getRowNumber(row);
            }
            if ((stepOccurrence = this.m_tableModel.getStepOccurrence(row)) != null && this.m_summaryPanel != null) {
                this.m_summaryPanel.displayStepOccurrence(stepOccurrence, true);
            }
        } else {
            this.updateStatusDetailsDialog();
            this.updateInformationStackDialog();
        }
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.createPopup(event);
        }
    }

    public void mouseReleased(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.createPopup(event);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        this.updateStatusDetailsDialog();
        this.updateInformationStackDialog();
    }

    void tabSelected(boolean selected) {
        this.m_tabSelected = selected;
    }

    public void removeReferences() {
        this.m_parentFrame = null;
        this.m_summaryPanel = null;
        this.removeMouseListener(this);
        for (int i = 0; i < this.m_columnModel.getColumnCount(); ++i) {
            this.m_columnModel.getColumn(i).setCellRenderer(null);
        }
        this.m_columnModel.getColumn(2).setHeaderRenderer(null);
        this.m_tableModel = null;
        this.m_tableSorter = null;
        this.m_columnModel = null;
        if (this.m_popup != null) {
            this.m_popup.removeAll();
            this.m_popup = null;
        }
        if (this.m_miDisplayStep != null) {
            this.m_miDisplayStep.removeActionListener(this.m_miDisplayStepActionListener);
            this.m_miDisplayStep = null;
        }
        this.m_miDisplayStepActionListener = null;
        if (this.m_miStatusDetails != null) {
            this.m_miStatusDetails.removeActionListener(this.m_miStatusDetailsActionListener);
            this.m_miStatusDetails = null;
        }
        this.m_miStatusDetailsActionListener = null;
        if (this.m_miInformationStack != null) {
            this.m_miInformationStack.removeActionListener(this.m_miInformationStackActionListener);
            this.m_miInformationStack = null;
        }
        this.m_miInformationStackActionListener = null;
        if (this.m_miLock != null) {
            this.m_miLock.removeActionListener(this.m_miLockActionListener);
            this.m_miLock = null;
        }
        this.m_miLockActionListener = null;
        if (this.m_miUnlock != null) {
            this.m_miUnlock.removeActionListener(this.m_miUnlockActionListener);
            this.m_miUnlock = null;
        }
        this.m_miUnlockActionListener = null;
        super.removeReferences();
    }
}

